<?php
session_start();


if (!$_SESSION['user_id']) {
    header("Location: ./../../index.php"); //redirect to login page to secure the welcome page without login access.  
}

include('./../../connection.php');
include('./../../providerConnection.php');
include('./../../Main/CommonUtility.php');

CommonUtility::hospFolderStructure($_SESSION['database']);
require_once './../../Main/Modal/Parameter_Value.php';
$parameterObj = new Parameter_Value($conn);
$maxCountForLoginMsgDisplay = $parameterObj->max_count_for_loginmsg_display();
$providerCode = mysqli_real_escape_string($con, $_SESSION['providerCode']);
$providerDetails = mysqli_fetch_object(mysqli_query($con, "SELECT language,license_expire_msg,license_end_date,type_of_license,is_multilocation_hospital FROM provider_master WHERE provider_code = '$providerCode' LIMIT 1 "));
$provider_language = $providerDetails->language ?? '';
$_SESSION['lang'] = !empty($provider_language) ? $provider_language : 'en';
$currentDate = date('Y-m-d');

$spaceDetails = mysqli_fetch_object(mysqli_query($con, "SELECT allocated_space,consumed_space FROM provider_master WHERE provider_code = '$providerCode' LIMIT 1 "));
$allocatedSpace = $spaceDetails->allocated_space;
$consumedSpace = round($spaceDetails->consumed_space, 3);
$_SESSION["allocatedSpace"] = $allocatedSpace;
$_SESSION["consumedSpace"] = $consumedSpace;

$PASSWORD_UPDATE_POLICY = $parameterObj->PASSWORD_UPDATE_POLICY();
$pwd_must_update = 'N';

//if Zero, no password expiration logic check
if($PASSWORD_UPDATE_POLICY > 0 && $_SESSION['user_id'] != 'thims'){
    
    $pwd_reminder_days = 7;
    $pwd_details = mysqli_fetch_object(mysqli_query($conn, "SELECT GREATEST(IFNULL(`old_pwd1_datetime`, '0000-00-00'), IFNULL(`old_pwd2_datetime`, '0000-00-00')) AS latest_date FROM user WHERE user_id = '{$_SESSION['user_id']}'"));
    $pwd_latest = $pwd_details->latest_date;

    if($pwd_latest == '0000-00-00 00:00:00'){
        $pwd_created_date = mysqli_fetch_object(mysqli_query($conn, "SELECT CreatedDate FROM user WHERE user_id = '{$_SESSION['user_id']}'"));
        $pwd_latest = $pwd_created_date->CreatedDate;
    }

    $current = new DateTime();            
    $latest = new DateTime($pwd_latest);  
    
    // $diff = date_diff($current, $latest);
    // $days_since_last_password_change = $diff->days;

    $interval = $latest->diff($current);
    $days_since_last_password_change = $interval->invert ? -$interval->days : $interval->days;
    

    if( $days_since_last_password_change >= $PASSWORD_UPDATE_POLICY){
        $pwd_must_update = 'Y';
    }

    if( ( $days_since_last_password_change + $pwd_reminder_days  ) > $PASSWORD_UPDATE_POLICY ){
        $pwd_remider_msg_show = 'Y';
        $pwd_expiri_remaining_days = $PASSWORD_UPDATE_POLICY - $days_since_last_password_change;
    }

}
?>
<head>
    <meta charset="UTF-8">
    <title>THIMS|HOME</title>
<?php include_once '../../links_head.php'; ?>
    <style>
        .jconfirm.jconfirm-bootstrap .jconfirm-box .jconfirm-buttons button {
            width: 135px;
        }
        .jconfirm.jconfirm-bootstrap .jconfirm-box .jconfirm-buttons .btn-default {
            display:none;
        }
        .jconfirm .jconfirm-box {
            width: 130%;
        }
        .jconfirm-buttons{
            text-align: center !important;
        }
        .alertIcon {
            margin-left: 0px;
        }
        .clock{
            font-size: 20pt;
            color:red;
            font-weight: bold;
            background-color: yellow;
            border-radius: 15px;
            width: 70px;
            text-align: center;
            padding-left: 10px;
            padding-right: 10px;
        }
        .expiryMsgDiv{
            text-align: center;
            font-weight: bold;
            font-size: 16pt;
        }
        mark {
            padding: 0px;
            color: #000;
            background: #ff0;
        }
        .blink {
            animation: blink 1s steps(1, end) infinite;
        }

        @keyframes blink {
            0% {
                opacity: 1;
            }
            50% {
                opacity: 0;
            }
            100% {
                opacity: 1;
            }
        }
        .jconfirm .jconfirm-box div.jconfirm-content-pane.no-scroll {
            text-align: center;
            margin-bottom: 40px !important;
            margin-top: 35px !important;
            height: 215px;
        }
        @media only screen and (max-width: 768px) {
            .fontResponsive > font{
                font-size: 37px !important
            }
        }
    </style>
</head>
<?php
include '../header.php';
include '../sidebar.php';
include '../../Components/Modals/hospitallocationModal.php';
?>


<body>
    <div id="imagePopup" class="modal fade" tabindex="-1" role="dialog" data-backdrop="static" aria-labelledby="imagePopupLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" style="margin-left: 25%;">
            <div class="modal-content">
                <div class="modal-header" style="border-bottom-color: #ffffff">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body" style="padding-top: 0px;">
                    <!--<img src="../../img/greetings.jpeg" style="width: 100%;height:85%" alt="Image to be displayed">-->
                    <video width="100%" height="78%" controls autoplay muted > <!-- playsinline-->
  <source src="../../img/greetings.mp4" type="video/mp4">
  Your browser does not support the video tag.
</video>
                    <br><br><!-- comment -->
                    <p style="font-weight:bold;color:#b30808;font-size: 17pt;">              
We are observing holidays from Monday, 20/10/2025 to Thursday,23/10/2025 on account of Dipawali festivals.
                    </p>
&nbsp;
                </div>
            </div>
        </div>
    </div>
    <div class="content-wrapper">

        <section class="content"> 
<?php
$greetingIMG = file_exists("../../img/greetings.mp4");
$license_expire_msg = $providerDetails->license_expire_msg;
$is_multilocation_hospital = $providerDetails->is_multilocation_hospital;
$datetime1 = new DateTime($currentDate);
$license_end_date = CommonUtility::encryptDecryptString('decrypt', $providerDetails->license_end_date);
$datetime2 = new DateTime($license_end_date);
$interval = $datetime2->diff($datetime1);
$days = $interval->days;

if ($providerDetails->type_of_license == 'L' && $days <= 60) {

    function appointmentReplaceMsgParameter($messageContent, $days, $license_end_date) {
        $array = array(
            "&&Days&&" => "<mark>$days</mark>",
            "&&Date&&" => "<mark>$license_end_date</mark>",
        );
        return str_replace(array_keys($array), array_values($array), $messageContent);
    }
    ?>
                <br><br><br>
                <div class="col-md-12" style="border: 1px solid black;">
                    <div class="col-md-1"><i class="fa fa-bell blink" style="font-size:48px;color:red;margin-top: 6px"></i></div>
                    <div class="col-md-11 expiryMsgDiv">
                        <font color="red" > <?php echo appointmentReplaceMsgParameter($license_expire_msg, $days, CommonUtility::getDisplayDate($license_end_date)); ?> </font>
                    </div>
                </div>
                <br><br><br>
            <?php }
            ?>
            <!-- Content Header (Page header) -->
            <!--<img src="../registration/img/logo.png" class="user-image" alt="User Image" style="width: 100%; height: 10%; margin-top: 23%;/>-->
            <br><br><br>
            <div class="login-logo">
                <input type="hidden" name="greetings_img" id="greetings_img" value="<?php echo $greetingIMG; ?>"/>
                <input type="hidden" name="allocated_space" id="allocated_space" value="<?php echo $allocatedSpace; ?>"/>
                <input type="hidden" name="consumed_space" id="consumed_space" value="<?php echo $consumedSpace; ?>"/>
                <input type="hidden" name="user_id" id="user_id" value="<?php echo $_SESSION['user_id']; ?>"/>
                <input type="hidden" name="multi_location" id="multi_location" value="<?php echo $is_multilocation_hospital; ?>"/>
                <input type="hidden" name="max_count_para" id="max_count_para" value="<?php echo $maxCountForLoginMsgDisplay; ?>"/>
                <input type="hidden" name="pwd_must_update" id="pwd_must_update" value="<?php echo $pwd_must_update; ?>"/>

                <b class="fontResponsive"><font style="font-size:80px"  color="#CC0000">Tech</font><font style="font-size:80px" color="#666666">Smith</font>'S
                    <br><font style="font-size:60px"><?php if ($_SESSION['logintype'] == 'lab') {
                echo "Laboratory ";
            } else if ($_SESSION['logintype'] == 'RIS') {
                echo "Radiology ";
            } else {
                echo 'Hospital ';
            } ?>Information Management System</font></b>
            </div>
            <div id="diskdiv" style="text-align: center;font-weight: bold;font-size: 25px;">
                <font color="">Total Disk Space Utilization : <?php echo $consumedSpace; ?> GB</font> 
            </div>
            <br><br><br>
            <div style="text-align: center;font-weight: bold;font-size: 14pt;">
                <font color="red">Support Contact Nos: <?php echo $_SESSION['support_contact_nos']; ?> </font> 
            </div>
        </section>   
    </div> 
</body>

<script src="../../js/notificationCheck.js?<?php echo $version_num; ?>"></script>
   <!--<script src="../../plugins/jQueryUI/jquery-ui.min.js" type="text/javascript"></script>-->     
<!-- Bootstrap 3.3.2 JS -->
<script src="../../bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
<!-- DATA TABES SCRIPT -->
<script src="../../plugins/jquery-ui-1.12.1/jquery-ui.min.js"></script>

<!-- FastClick -->
<script src="../../plugins/fastclick/fastclick.min.js" type="text/javascript"></script>
<!-- AdminLTE App -->
<script src="../../dist/js/app.min.js" type="text/javascript"></script>
<script>
    $(document).ready(function () {

        var pwd_must_update = $("#pwd_must_update").val();
        var pwd_expiri_remaining_days = '<?=  $pwd_expiri_remaining_days; ?>';
        var pwd_remider_msg_show = '<?=  $pwd_remider_msg_show; ?>';

        if(pwd_must_update == 'N' &&  pwd_remider_msg_show == 'Y'){
            var actionButton = function () { 
                window.location.href = "../setup/change_password.php"

                }
            informationDialog_withOkBtn_pwd("Your password is set to expire in " + pwd_expiri_remaining_days + " days. Please update it or Continue....",actionButton,'y')

        }
        
        if(pwd_must_update == 'Y' ){
            var actionButton = function () { 
                   window.location.href = "../setup/change_password.php?pwd=y"
                }

            informationDialog_withOkBtn_pwd('Your password has expired. Please update it to continue !!!',actionButton,'n')

        }

        var greetings_img = $("#greetings_img").val();
        if (greetings_img == 1) {
            $("#imagePopup").modal("show");
            setTimeout(function () {
                $("#imagePopup").modal("hide");
            }, 15000);
        }

        var multi_location = $("#multi_location").val();
        if (multi_location == 'Y') {
//            $('#hospitalLocationModal').modal('show');
            $('#hospitalLocationModal').modal({backdrop: 'static', keyboard: false}, 'show');
        }


//        $('#hospitalLocationModal').modal({
//            backdrop: 'static',
//            keyboard: false
//        });
        $('#locationModalSubmit').click(function () {
            var h_center = $("#h_center").val();
            var multi_location = $("#multi_location").val();
            if (h_center != '') {
                $.ajax({
                    url: '../../ajax/hospitalLocationSave.php',
                    method: "POST",
                    data: {
                        saveData: 'Y', h_center: h_center, multi_location: multi_location
                    },
                    success: function (data) {
                        $('#hospitalLocationModal').modal('hide');
                    },
                    error: function (error, xhr, status) {
                        console.log(error);
                        console.log(xhr.responseText);
                        console.log(status);
                    }
                });
            } else {
                errorDialog("Please Select Location");
            }

        });
        var consumedSpace =$("#consumed_space").val();
        var allocatedSpace = $("#allocated_space").val();
        var consumedPercentage = (100 * consumedSpace) / allocatedSpace;
        if (consumedPercentage < 75) {
            $('#diskdiv').css('color', '#00b050');
        } else if (consumedPercentage < 90) {
            $('#diskdiv').css('color', '#ffc000');
        } else {
            $('#diskdiv').css('color', '#ff0000');
        }

    });

    function informationDialog_withOkBtn_pwd(confirmMessage,  actionButton,isContinue) {
        console.log(isContinue);
        
            var submitOptions = {
                text: 'Update',
                btnClass: 'btn-primary'
            }
            if(isContinue == 'y'){
                var continueOptions = {
                            text: 'Continue',
                            btnClass: 'btn-primary'
                        }
            }
            if(actionButton!=undefined || actionButton != ''){
                submitOptions.action=actionButton;
            }   
               
    
            $.confirm({
                buttons: {
                    Submit: submitOptions,
                    continue: continueOptions
                },
                title: '<img class="alertLogo" src="./../../img/'+fileName+'"></img>',
                content: '<i style="color:#337ab7;" class="fa fa-exclamation-circle alertIcon"></i><br> <br><div class="center" style="background-color:yellow"><b class="alertMsg"> '+confirmMessage+'</b></div>',
                theme: 'bootstrap',
                closeIcon: false,
                animation: 'scale',
                type: 'dark'
            });
    }
</script>
</html>
